import metrics from '../../metrics';
import {setEditMode as setEditModeAction} from '../../common/actions';
import {
    ADDRESSES_GOAL_PREFIX,
    EDIT_MODE_ADDRESSES,
    EDIT_MODE_DELIVERY_ADDRESSES,
    ADDRESSES_LINK,
    setAddressesEditMode
} from './actions';
import {push} from 'react-router-redux';

export function sendMetrics(goal) {
    metrics.goal(`${ADDRESSES_GOAL_PREFIX}_${goal}`);
}

export function setEditMode(mode = EDIT_MODE_ADDRESSES) {
    const {dispatch, settings = {}} = this.props;
    const {ua = {}} = settings;
    const {isMobile, isTouch, isTablet} = ua;
    const isPhone = (isMobile || isTouch) && !isTablet;

    dispatch(setAddressesEditMode(mode));
    if (!isPhone) {
        dispatch(setEditModeAction(mode));
    } else {
        dispatch(push(ADDRESSES_LINK));
    }
}

export function showAddresses(event) {
    this.setEditMode(EDIT_MODE_ADDRESSES);
    event.preventDefault && event.preventDefault();
}

export function showDeliveryAddresses(event) {
    this.setEditMode(EDIT_MODE_DELIVERY_ADDRESSES);
    event.preventDefault && event.preventDefault();
}
