import React from 'react';
import {Modal} from '@components/Modal';
import {Link} from '@components/Link';
import {push} from 'react-router-redux';
import {TwoFA} from '@blocks/morda/components/twofa/twofa.jsx';
import {setEditMode, showRegPopup} from '@blocks/common/actions';
import {showHint} from '@blocks/morda/access/actions';
import {getTokensList} from './index';
import {showDisableScreen} from './actions';
import {CreateAppPassword} from '@blocks/morda/components/create_app_passwords/create_app_passwords.jsx';
import {AppPasswordsList} from './app_passwords_list.jsx';
import {LINK_CLASS_NAME} from '@blocks/link.jsx';

export class AppPasswords extends TwoFA {
    getErrorModal() {} // eslint-disable-line no-empty-function

    constructor(props) {
        super(props);
        this.displayName = 'app-passwords';
        this.showAppPasswordsModal = this.showAppPasswordsModal.bind(this);
        this.showDisableScreen = this.showDisableScreen.bind(this);
        this.redirectToAppPasswordsList = this.redirectToAppPasswordsList.bind(this);
    }

    sendMetrics(msg) {
        this.props.sendMetrics('Включить пароли приложений: ', msg);
    }

    showAppPasswordsModal() {
        const {dispatch, appPasswords, settings} = this.props;
        const isPhone = (settings.ua.isMobile || settings.ua.isTouch) && !settings.ua.isTablet;

        if (isPhone) {
            this.redirectToAppPasswordsList();
            return;
        }

        if (appPasswords.tokens.appPasswordsCount > 0) {
            dispatch(getTokensList());
        }
        dispatch(setEditMode('apppasswords-list'));
    }

    showDisableScreen() {
        const {settings} = this.props;
        const isPhone = (settings.ua.isMobile || settings.ua.isTouch) && !settings.ua.isTablet;

        this.props.dispatch(showDisableScreen(true));
        if (isPhone) {
            this.redirectToAppPasswordsList();
            return;
        }
        this.props.dispatch(setEditMode('apppasswords-list'));
    }

    onLinkClick() {
        const props = this.props;
        const {passwordStrength, dispatch, canChangePassword, is2faEnabled, settings} = props;
        const isPhone = (settings.ua.isMobile || settings.ua.isTouch) && !settings.ua.isTablet;

        if (canChangePassword !== undefined && !canChangePassword) {
            this.showErrorModal();
            return;
        }

        if (passwordStrength === -1 && !is2faEnabled) {
            dispatch(showRegPopup(true));
            return;
        }

        if (isPhone) {
            this.redirectToAppPasswordsList();
            return;
        }

        dispatch(setEditMode('apppasswords-list'));
        dispatch(showHint(''));
    }

    redirectToAppPasswordsList() {
        const {retpath, dispatch} = this.props;

        let redirectUrl = '/profile/apppasswords-list';

        if (retpath) {
            redirectUrl += `?retpath=${encodeURIComponent(retpath)}`;
        }

        dispatch(push(redirectUrl));
    }

    render() {
        const {
            edit,
            dispatch,
            settings,
            retpath,
            isEnabled,
            appPasswords,
            enabledStateMenu,
            is2faEnabled,
            isSocialchik
        } = this.props;
        const isPhone = (settings.ua.isMobile || settings.ua.isTouch) && !settings.ua.isTablet;
        const is2faDisabled = !is2faEnabled;
        const count = appPasswords.tokens.appPasswordsCount;
        const linkText = count && count > 0 ? `${enabledStateMenu.title}: ${count}` : enabledStateMenu.title;

        return (
            <div className='section-wrapper'>
                {isEnabled ? (
                    <div>
                        {Boolean(linkText) && (
                            <div className='p-control-link p-control-link__bold' ref='hint-anchor'>
                                <span onMouseDown={() => this.sendMetrics('переход по ссылке')}>
                                    <span
                                        onClick={this.showAppPasswordsModal}
                                        data-t='access-widget:passwords'
                                        className={LINK_CLASS_NAME}
                                    >
                                        {linkText}
                                    </span>
                                </span>
                            </div>
                        )}

                        <CreateAppPassword
                            dispatch={dispatch}
                            settings={settings}
                            edit={edit}
                            retpath={retpath}
                            appPasswords={appPasswords}
                            isSocialchik={isSocialchik}
                            isAppPasswordsEnabled={isEnabled}
                        />

                        {Boolean(is2faDisabled) && (
                            <div className='p-control-link' data-t='access-widget:passwords-disable'>
                                <Link pseudo={true} onClick={this.showDisableScreen}>
                                    {enabledStateMenu.disableText}
                                </Link>
                            </div>
                        )}
                    </div>
                ) : (
                    <div>
                        <div
                            className='p-control-link p-control-link__bold'
                            data-t='access-widget:passwords-enable'
                            ref='hint-anchor'
                        >
                            <Link pseudo={true} onClick={this.onLinkClick}>
                                {isEnabled ? this.props.disableText : this.props.enableText}
                            </Link>
                            {Boolean(!isPhone) && (
                                <span>
                                    <span
                                        className='show-hint__icon'
                                        onClick={this.showHint}
                                        onMouseDown={() => this.sendMetrics('переход по ссылке')}
                                    />
                                    {this.getErrorModal()}
                                    {this.getHintPopup()}
                                </span>
                            )}
                        </div>
                        <div className='section-body-info section-body-info__bottom_shift'>
                            {this.props.descriptionMessage}
                        </div>
                    </div>
                )}

                {Boolean(!isPhone) && (
                    <Modal
                        visible={this.props.edit === 'apppasswords-list'}
                        zIndexGroupLevel={-0.5}
                        dataT='app-passwords'
                    >
                        <AppPasswordsList
                            modal={true}
                            isEnabled={isEnabled}
                            edit={edit}
                            dispatch={dispatch}
                            settings={settings}
                            is2faEnabled={is2faEnabled}
                            appPasswords={appPasswords}
                        />
                    </Modal>
                )}
            </div>
        );
    }
}

AppPasswords.defaultProps = {
    enableText: i18n('Profile.apppasswords.enable'),
    disableText: i18n('Profile.apppasswords.disable'),
    actionLink: '/profile/access?origin=passport_profile#open_popup',
    hintTitle: i18n('Profile.apppasswords.hint.title'),
    hintMessage: i18n('Profile.apppasswords.hint.message'),
    descriptionMessage: i18n('Profile.apppasswords.description.message'),
    enabledStateMenu: {
        title: i18n('Profile.apppasswords.main.title'),
        disableText: i18n('Profile.common.disable')
    }
};
