import api from '@blocks/api';
import {saveActionForRepeat, setEditMode} from '@blocks/common/actions';
import {getAppPasswordsList, setAppPasswordsNumber, showDisableScreen} from './actions';
import {updateAppPasswordsStatus} from '@blocks/morda/access/actions';
import {clientLocNames} from '@blocks/morda/create_app_passwords';

export function countAppPasswords(callback) {
    return (dispatch, getState) => {
        const state = getState();
        const data = {
            lang: state.settings.language,
            csrf_token: state.common.csrf
        };

        api.request('apppasswords.count', data)
            .then((response) => {
                if (response && response.status === 'ok') {
                    dispatch(setAppPasswordsNumber(response.app_passwords_count));
                }
            })
            .always(callback);
    };
}

export function getTokensList() {
    return (dispatch, getState) => {
        const state = getState();
        const data = {
            lang: state.settings.language,
            csrf_token: state.common.csrf
        };

        api.request('apppasswords.list', data).then((response) => {
            response.map((token) => localizeClientName(token));
            dispatch(getAppPasswordsList(response));
        });
    };
}

export function revokeToken(id) {
    return (dispatch, getState) => {
        const state = getState();
        const tokensList = state.appPasswords.tokens.list;
        const data = {
            lang: state.settings.language,
            tokenId: id,
            csrf_token: state.common.csrf
        };

        dispatch(saveActionForRepeat(revokeToken, id));
        api.request('apppasswords.token-revoke', data).then((response) => {
            if (response && response.status === 'ok') {
                const resultList = tokensList.filter(function(el) {
                    return el.tokenId !== parseInt(id, 10);
                });
                const numberOfTokens = resultList.length;

                dispatch(getAppPasswordsList(resultList));
                dispatch(setAppPasswordsNumber(numberOfTokens));
            }
        });
    };
}

export function disableApplicationPasswords() {
    return (dispatch, getState) => {
        const state = getState();
        const data = {
            track_id: state.common.track_id,
            csrf_token: state.common.csrf
        };

        dispatch(saveActionForRepeat(disableApplicationPasswords, data));
        api.request('appPwdDeactivate', data).then((response) => {
            const body = response.body;

            if (body && body.status === 'ok') {
                dispatch(updateAppPasswordsStatus(false));
                dispatch(showDisableScreen(false));
                dispatch(countAppPasswords(0));
                dispatch(setEditMode('null'));
            }
        });
    };
}

export function activateApplicationPasswords() {
    return (dispatch, getState) => {
        const state = getState();
        const data = {
            track_id: state.common.track_id,
            csrf_token: state.common.csrf
        };

        dispatch(saveActionForRepeat(activateApplicationPasswords, data));
        api.request('appPwdActivate', data).then((response) => {
            const body = response.body;

            if (body && body.status === 'ok') {
                dispatch(updateAppPasswordsStatus(true));
            }
        });
    };
}

function localizeClientName(token) {
    const localizedToken = token;
    const client = clientLocNames[token.client];

    localizedToken.name = client ? client.title : '';
    return localizedToken;
}
