import {GET_APPPASSWORDS_TOKENS, COUNT_APPPASSWORDS, UPDATE_TOKEN_TAB, SHOW_DISABLE_SCREEN} from './actions';

export default function tokens(state = {}, action) {
    switch (action.type) {
        case COUNT_APPPASSWORDS:
            return $.extend({}, state, {
                appPasswordsCount: action.count
            });
        case GET_APPPASSWORDS_TOKENS:
            return $.extend({}, state, state.appPasswords, {
                list: action.tokensList
            });
        case SHOW_DISABLE_SCREEN:
            return $.extend({}, state, state.appPasswords, {
                showDisableScreen: action.showValue
            });
        case UPDATE_TOKEN_TAB: {
            const tokensList = state.list;
            const index = tokensList.findIndex((token) => token.tokenId === parseInt(action.id, 10));
            const status = state.list[index] && !state.list[index].tabOpened;
            const updatedItem = $.extend({}, state.list[index], {
                tabOpened: status
            });
            const newList = tokensList.filter(function(el) {
                return el.tokenId !== parseInt(action.id, 10);
            });

            newList.splice(index, 0, updatedItem);
            return $.extend({}, state, {
                list: newList
            });
        }
        default: {
            return state;
        }
    }
}
