import api from '../../../api';
import {updateAvatar, updateAvatarStatus, setAvatarError} from './';
import updateAvatarId from './updateAvatarId';
import processErrors from '../helpers/processErrors';

export default function deleteAvatar() {
    return (dispatch, getState) => {
        const state = getState() || {};
        const {changeAvatar = {}} = state;
        const {track_id: trackId, defaultUrl} = changeAvatar;
        const data = {
            track_id: trackId,
            csrf_token: state.common.csrf
        };

        dispatch(updateAvatarStatus('loading'));
        api.request('avatars/delete', data)
            .done((response) => {
                if (response && response.status === 'ok') {
                    dispatch(
                        updateAvatar({
                            avatarUrl: defaultUrl,
                            isDeletePossible: false
                        })
                    );
                    dispatch(updateAvatarStatus('normal'));
                    dispatch(updateAvatarId(defaultUrl));
                } else {
                    dispatch(setAvatarError(processErrors(response)));
                }
            })
            .fail(() => {
                dispatch(setAvatarError('error-internal'));
            });
    };
}
