import api from '../../../api';
import {updateAvatar, setAvatarError, updateAvatarStatus} from './index';
import processErrors from '../helpers/processErrors';

export default function getInitialAvatarsTrack() {
    return (dispatch, getState) => {
        const state = getState();
        const {
            changeAvatar: {defaultSize, defaultUrl}
        } = state;
        const initialData = setInitialAvatarData(state);

        dispatch(updateAvatarStatus('normal'));

        if (!initialData.isSetByQueryUid) {
            dispatch(
                updateAvatar({
                    avatarUrl: initialData.url,
                    isDeletePossible: initialData.isDeletePossible
                })
            );
        }

        api.request('avatars/init', {uid: initialData.uidToPass})
            .done((response) => {
                const body = response.body;

                if (body && body.status === 'ok' && body.avatars) {
                    const avatarInfo = body.avatars.find((item) => item.default);
                    const data = {
                        track_id: body.track_id,
                        isDeletePossible: Boolean(avatarInfo && avatarInfo.id),
                        backupAvatar: {
                            url: avatarInfo ? `https://${avatarInfo.url}${defaultSize}` : defaultUrl
                        }
                    };

                    if (avatarInfo && avatarInfo.url && initialData.isSetByQueryUid) {
                        data.avatarUrl = `https://${avatarInfo.url}${defaultSize}`;
                    }

                    dispatch(updateAvatar(data));
                    api.writeStatbox({
                        mode: 'profile_change_avatar',
                        action: 'opened',
                        track_id: body.track_id
                    });
                }
                if (!body && Array.isArray(response)) {
                    dispatch(setAvatarError(processErrors(response)));
                }
            })
            .fail((error) => {
                dispatch(setAvatarError(processErrors(error)));
            });
    };
}

function setInitialAvatarData(state) {
    const {
        settings,
        person: {avatarId},
        changeAvatar,
        common
    } = state;
    const avatarPath = settings.avatar.avatar_300;
    const uidFromQuery = changeAvatar.queryUid;
    const isProfilePage = settings.location === '/profile/';

    return {
        url: avatarPath.replace('%avatar_id%', avatarId),
        isDeletePossible: avatarId !== '0/0-0',
        isSetByQueryUid: uidFromQuery && !isProfilePage,
        uidToPass: uidFromQuery && !isProfilePage ? uidFromQuery : common.uid
    };
}
