import {updateAvatar, setAvatarError, updateAvatarStatus, updateImageOptions} from './';
import {avatarCropper} from '../helpers/avatarCropper';
import defineConvertOptions from '../helpers/defineConvertOptions';

export default function loadAvatarByFile(file, isCropNotSupported) {
    return (dispatch) => {
        dispatch(avatarCropper.destroyCropImage());

        if (!file) {
            return;
        }

        const allowedFileTypes = ['png', 'jpg', 'jpeg', 'gif'];
        // eslint-disable-next-line compat/compat
        const reader = new FileReader();
        const fileType = file.type.split('/')[0];
        const imageType = file.type.split('/')[1];
        const MAX_FILE_SIZE_BYTES = 7340032;
        const checkIfSizeIsOk = () => {
            if (file.size > MAX_FILE_SIZE_BYTES) {
                dispatch(setAvatarError('error-file.size'));
                return false;
            }
            return true;
        };
        const checkIfIsImage = () => {
            if (fileType !== 'image') {
                dispatch(setAvatarError('error-file.invalid'));
                return false;
            }
            return true;
        };
        const fileInfo = defineConvertOptions(imageType, file.size);

        if (!allowedFileTypes.includes(imageType)) {
            return dispatch(setAvatarError('error-file.invalid'));
        }

        if (!isCropNotSupported) {
            dispatch(
                updateImageOptions({
                    type: fileInfo.type,
                    compression: fileInfo.compression
                })
            );
        }

        if (checkIfIsImage() && checkIfSizeIsOk()) {
            dispatch(updateAvatarStatus('loading'));

            reader.onload = (event) => {
                const testImg = new Image();
                const minRange = 200;
                const data = {
                    avatarUrl: event.target.result,
                    error: ''
                };

                testImg.src = event.target.result;
                testImg.onload = () => {
                    const width = testImg.naturalWidth || testImg.width;
                    const height = testImg.naturalHeight || testImg.height;

                    if (width < minRange || height < minRange) {
                        dispatch(avatarCropper.destroyCropImage('error-image.size'));
                        return;
                    }
                    dispatch(updateAvatarStatus('processing'));

                    if (isCropNotSupported) {
                        const form = document.getElementById('load_avatar');

                        if (form) {
                            dispatch(updateAvatarStatus('loading'));
                            form.submit();
                            return;
                        }

                        dispatch(setAvatarError('error-internal'));
                    } else {
                        dispatch(updateAvatar(data));
                        avatarCropper.init();
                    }
                };
            };

            reader.onerror = () => {
                dispatch(setAvatarError('error-internal'));
                dispatch(updateAvatarStatus('normal'));
            };
            reader.readAsDataURL(file);
        }
    };
}
