import api from '../../../api';
import {avatarCropper} from '../helpers/avatarCropper';
import forceClearFileInput from '../helpers/forceClearFileInput';
import handleErrorsFromLoadByUrl from '../helpers/handleErrorsFromLoadByUrl';
import {setAvatarError, updateAvatar, updateAvatarStatus} from './';

export default function loadAvatarByUrl(path) {
    // load by URL new avatars
    return (dispatch, getState) => {
        const state = getState() || {};
        const {changeAvatar = {}} = state;
        const {track_id: trackId, loadUrlPath} = changeAvatar;
        const url = path || loadUrlPath;

        const query = {
            track_id: trackId,
            url,
            csrf_token: state.common.csrf,
            isTemp: true
        };
        const maxSymbolLength = 1024;

        avatarCropper.destroyCropper();
        forceClearFileInput();
        dispatch(setAvatarError(''));
        dispatch(
            updateAvatar({
                isByUrl: true
            })
        );

        if (!url || !url.trim()) {
            dispatch(setAvatarError('error-url.empty'));
            return;
        }

        if (url.length > maxSymbolLength) {
            dispatch(setAvatarError('error-url.invalid'));
            return;
        }

        dispatch(updateAvatarStatus('loading'));
        api.request('avatars/upload', query).done((response = {}) => {
            if (response.body && response.body.status === 'ok') {
                const imgUrl = `https://${response.body.avatar_url}islands-300`;

                dispatch(updateAvatarStatus('processing'));
                dispatch(
                    updateAvatar({
                        avatarUrl: `/profile/avatars/image?path=${imgUrl}`,
                        error: ''
                    })
                );
                avatarCropper.init();
            } else {
                if (Array.isArray(response)) {
                    handleErrorsFromLoadByUrl(response, dispatch);
                } else {
                    dispatch(setAvatarError('error-internal'));
                }
                dispatch(updateAvatarStatus('normal'));
            }
        });
    };
}
