import {updateHeaderAvatar} from '@blocks/morda/components/header/actions';
import {updateMainAvatar} from '@blocks/morda/personal_info/actions';
import {updateAvatar} from './';

export default function updateAvatarId(url) {
    return (dispatch, getState) => {
        const {changeAvatar, settings} = getState();
        const queryUid = changeAvatar.queryUid;
        const isPhone = settings.ua && settings.ua.isMobile;

        let avatarId = '0/0-0';

        if (url) {
            const splitUrl = url.split('/');

            avatarId = `${splitUrl[4]}/${splitUrl[5]}`;
        }

        if (!queryUid) {
            // we have default user in Header and should not update its avatar
            dispatch(updateHeaderAvatar(avatarId));
        }
        if (queryUid && isPhone) {
            dispatch(updateAvatar({queryUid: ''}));
        }

        dispatch(updateMainAvatar(avatarId));
    };
}
