import {updateAvatar, updateAvatarStatus} from './index';
import updateAvatarId from './updateAvatarId';

export default function updateAvatarImage(url) {
    return (dispatch, getState) => {
        const {changeAvatar} = getState();
        const {defaultSize, defaultUrl, status} = changeAvatar;

        const imagePath = url ? `//${url}${defaultSize}` : defaultUrl;
        const data = {
            avatarUrl: imagePath,
            backupAvatar: {
                url: imagePath
            },
            error: '',
            isDeletePossible: true
        };

        dispatch(updateAvatarStatus(status));
        dispatch(updateAvatar(data));
        dispatch(updateAvatarId(imagePath));
    };
}
