import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Modal} from '@components/Modal';
import {AvatarInfo} from './components/avatar.jsx';
import {setEditMode} from '@blocks/common/actions';
import {avatarCropper} from './helpers/avatarCropper';

class AvatarContainer extends Component {
    static mapStateToProps(state) {
        const {settings, common, changeAvatar} = state;
        const {edit, retpath, uid} = common;

        return {
            settings,
            edit,
            uid,
            retpath,
            changeAvatar
        };
    }

    closeModal = () => {
        const {dispatch} = this.props;

        dispatch(setEditMode(null));
        dispatch(avatarCropper.destroyCropImage());
    };

    render() {
        const {edit, retpath, uid, settings, changeAvatar} = this.props;
        const modalOpened = edit === 'edit-avatar';

        return (
            <Modal visible={modalOpened} onCloserClick={this.closeModal} dataT='avatar-container'>
                {modalOpened && (
                    <AvatarInfo
                        modal={true}
                        edit={edit}
                        retpath={retpath}
                        uid={uid}
                        dispatch={this.props.dispatch}
                        changeAvatar={changeAvatar}
                        settings={settings}
                    />
                )}
            </Modal>
        );
    }
}

export default connect(AvatarContainer.mapStateToProps)(AvatarContainer);

AvatarContainer.propTypes = {
    edit: PropTypes.string,
    uid: PropTypes.number,
    retpath: PropTypes.oneOfType([PropTypes.string, PropTypes.object]),
    settings: PropTypes.object,
    changeAvatar: PropTypes.object,
    dispatch: PropTypes.func
};
