import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Attach} from '@components/Attach';
import {ErrorMessage} from './error.jsx';
import sendMetrics from '../helpers/sendAvatarMetrics';

export default class AddFile extends PureComponent {
    constructor(props) {
        super(props);

        this.checkError = this.checkError.bind(this);
    }

    checkError(error) {
        const errors = [
            'error-file.invalid',
            'error-image.size',
            'error-file.empty',
            'error-file.size',
            'error-limit.file'
        ];

        return errors.includes(error);
    }

    render() {
        const {trackId, disabled, handleFile, errorType, isByUrl, status} = this.props;

        return (
            <div className='avatar-load_item'>
                <div className='field-text'>{i18n('Profile.avatar.load-text')}</div>
                <FileSend
                    status={status}
                    trackId={trackId}
                    isByUrl={isByUrl}
                    disabled={disabled}
                    handleFile={handleFile}
                />
                <ErrorMessage visible={this.checkError(errorType)} errorType={errorType} />
            </div>
        );
    }
}

AddFile.propTypes = {
    trackId: PropTypes.string,
    disabled: PropTypes.bool,
    handleFile: PropTypes.func,
    errorType: PropTypes.string,
    status: PropTypes.string,
    isByUrl: PropTypes.bool
};

const FileSend = (props) => {
    let oldBadBrowser = false;
    const {status, isByUrl, handleFile, trackId, disabled} = props;
    const isProcessing = status === 'processing';
    const isHolderShowing = isProcessing && !isByUrl;

    if (process.env.BROWSER) {
        if (!window.File || !window.FileReader) {
            oldBadBrowser = true;
        }
    }

    if (oldBadBrowser) {
        return (
            <form method='post' encType='multipart/form-data' id='load_avatar' action='/profile/avatars/legacy/'>
                <span onMouseDown={sendMetrics} id='profile_page_load_avatar' data-msg='Загрузить'>
                    <input type='file' name='file' className='simple__input' onChange={handleFile} />
                    <input type='hidden' name='track_id' value={trackId} />
                </span>
            </form>
        );
    }

    return (
        <span onMouseDown={sendMetrics} id='profile_page_load_avatar' data-msg='Загрузить'>
            <Attach
                view='pseudo'
                width='max'
                size='m'
                disabled={disabled || (isProcessing && isByUrl)}
                hasHolder={isHolderShowing}
                onReset={handleFile}
                onChange={handleFile}
            >
                {i18n('Profile.avatar.choose-file')}
            </Attach>
        </span>
    );
};

FileSend.propTypes = {
    handleFile: PropTypes.func.isRequired,
    trackId: PropTypes.string,
    disabled: PropTypes.bool,
    status: PropTypes.string,
    isByUrl: PropTypes.bool
};
