import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

const messages = {
    'error-file.empty': i18n('_AUTH_.avatar.file-empty'),
    'error-file.size': i18n('_AUTH_.avatar.file-size'),
    'error-url.file.size': i18n('_AUTH_.avatar.file-size'),
    'error-image.size': i18n('_AUTH_.avatar.image-size'),
    'error-url.image_size': i18n('_AUTH_.avatar.image-size'),
    'error-url.empty': i18n('_AUTH_.avatar.file-empty'),
    'error-file.invalid': i18n('_AUTH_.avatar.file-invalid'),
    'error-url.invalid': i18n('_AUTH_.avatar.url-invalid'),
    'error-internal': i18n('_AUTH_.avatar.error-internal'),
    'error-limit': i18n('_AUTH_.avatar.error-limit'),
    'error-limit.file': i18n('_AUTH_.avatar.file-error-limit')
};

export const ErrorMessage = (props) => {
    return (
        props.visible && (
            <div
                className={classNames('avatar-error', 'p-control-error-block', {
                    'p-control-error-block__internal': props.errorType === 'error-internal'
                })}
            >
                <div className='p-control-error-block-msg' aria-live='polite'>
                    {messages[props.errorType]}
                </div>
            </div>
        )
    );
};

ErrorMessage.propTypes = {
    errorType: PropTypes.string,
    visible: PropTypes.bool
};
