import React from 'react';
import PropTypes from 'prop-types';
import AddFile from './addFile.jsx';
import AddUrl from './addUrl.jsx';

export const AvatarLoadControls = (props) => {
    return (
        <div className='avatar-load block-item'>
            <AddFile
                status={props.status}
                isByUrl={props.isByUrl}
                trackId={props.trackId}
                disabled={props.disabled}
                errorType={props.errorType}
                handleFile={props.handleFile}
            />

            <AddUrl
                dispatch={props.dispatch}
                hasAvatarChanged={props.hasAvatarChanged}
                disabled={props.disabled}
                errorType={props.errorType}
                isByUrl={props.isByUrl}
                handleUrl={props.handleUrl}
                checkField={props.checkField}
            />
            <div className='avatar-size_description'>{i18n('_AUTH_.avatar.conditions')}</div>
        </div>
    );
};

AvatarLoadControls.propTypes = {
    props: PropTypes.object,
    trackId: PropTypes.string.isRequired,
    errorType: PropTypes.string,
    disabled: PropTypes.bool,
    handleFile: PropTypes.func.isRequired,
    handleUrl: PropTypes.func.isRequired,
    checkField: PropTypes.func.isRequired,
    status: PropTypes.string,
    hasAvatarChanged: PropTypes.bool,
    isByUrl: PropTypes.bool,
    dispatch: PropTypes.func.isRequired
};
