import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';
import deleteAvatar from '../actions/deleteAvatar';

export default class AvatarImage extends PureComponent {
    constructor(props) {
        super(props);
        this.deleteAvatar = this.deleteAvatar.bind(this);
    }

    deleteAvatar() {
        this.props.dispatch(deleteAvatar());
    }

    render() {
        const avatarInfo = this.props.avatarInfo;
        const avatarPath = avatarInfo.url;
        const isLoading = avatarInfo.status === 'loading';
        const {isDeletePossible} = avatarInfo;
        const defaultImgPath = avatarInfo.defaultUrl;

        return (
            <div className='avatar-image block-item'>
                <span className='personal-spinner'>
                    <Spin progress={isLoading} size='m' />
                </span>
                <div className='field-text'>
                    {avatarInfo.status === 'processing'
                        ? i18n('Profile.avatar.choose-image')
                        : i18n('Profile.avatar.current-image')}
                </div>
                <div className='image-box'>
                    {avatarPath ? (
                        <div>
                            {isDeletePossible && (
                                <button
                                    type='button'
                                    className='delete-avatar'
                                    onClick={this.deleteAvatar}
                                    title={i18n('Profile.common.delete')}
                                />
                            )}
                            <img src={avatarPath} id='user-avatar' />
                        </div>
                    ) : (
                        <img src={defaultImgPath} className='default-img' />
                    )}
                </div>
            </div>
        );
    }
}

AvatarImage.propTypes = {
    avatarInfo: PropTypes.shape({
        backupAvatar: PropTypes.object,
        defaultUrl: PropTypes.string,
        error: PropTypes.string,
        hasChanged: PropTypes.bool,
        id: PropTypes.number,
        isByUrl: PropTypes.bool,
        status: PropTypes.string,
        track_id: PropTypes.string,
        url: PropTypes.string,
        isDeletePossible: PropTypes.bool
    }),
    dispatch: PropTypes.func
};
