import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Button} from '@components/Button';
import {ErrorMessage} from './error.jsx';
import loadAvatarByFile from '@blocks/morda/avatar/actions/loadAvatarByFile';

const checkFileError = (error) => {
    const errors = ['error-file.invalid', 'error-image.size', 'error-file.empty', 'error-file.size'];

    return errors.includes(error);
};

class SimpleForm extends Component {
    // Android version < 5 in native browser doesn't work cropper
    static mapStateToProps(state) {
        const {common, changeAvatar} = state;
        const csrf = common.csrf;
        const {error, track_id, status} = changeAvatar;

        return {
            csrf,
            trackId: track_id,
            isLoading: status === 'loading',
            errorType: error
        };
    }

    handleFileForSimpleV = (event) => {
        const file = event.target.files[0];

        this.props.dispatch(loadAvatarByFile(file, true));
    };

    render() {
        const {csrf, errorType, trackId, isLoading} = this.props;

        return (
            <form
                method='post'
                encType='multipart/form-data'
                id='load_avatar'
                action='/profile/avatars/legacy/'
                onSubmit={this.handleSubmit}
            >
                <div className='avatar-load block-item'>
                    <input type='hidden' name='csrf_token' value={csrf} />
                    <input type='hidden' name='track_id' value={trackId} />
                    <span>
                        <input type='file' name='file' className='simple__input' onChange={this.handleFileForSimpleV} />
                    </span>
                    <ErrorMessage visible={checkFileError(errorType)} errorType={errorType} />

                    <div className='avatar-size_description'>{i18n('_AUTH_.avatar.conditions')}</div>
                </div>
                <div className='avatar-buttons'>
                    <div className='edit-avatar_btn-save'>
                        <Button view='action' size='l' width='max' type='button' disabled={isLoading}>
                            {i18n('_AUTH_.common.save')}
                        </Button>
                    </div>
                    <div className='edit-avatar_btn-cancel'>
                        <Button view='pseudo' size='l' type='link' url='/profile' width='max'>
                            {i18n('_AUTH_.common.cancel')}
                        </Button>
                    </div>
                </div>
            </form>
        );
    }
}

export default connect(SimpleForm.mapStateToProps)(SimpleForm);

SimpleForm.propTypes = {
    trackId: PropTypes.string,
    csrf: PropTypes.string,
    errorType: PropTypes.string,
    isLoading: PropTypes.string,
    dispatch: PropTypes.func.isRequired
};
