export default function defineConvertOptions(originFileType = 'jpeg', size) {
    const qualityParams = {
        type: originFileType,
        compression: 0.6
    };
    const FOUR_MB_IN_BYTES = 4194304;
    const ONE_MB_IN_BYTES = 1048576;
    const isLarge = size >= FOUR_MB_IN_BYTES;
    const isMedium = size < FOUR_MB_IN_BYTES && size >= ONE_MB_IN_BYTES;
    const isPNGorGIF = originFileType === 'gif' || originFileType === 'png';

    if (isPNGorGIF && isMedium) {
        qualityParams.type = 'jpeg';
    }

    if (isLarge) {
        qualityParams.type = 'jpeg';
        qualityParams.compression = 0.5;
    }

    return qualityParams;
}
