import {setAvatarError} from '../actions/index';
import processErrors from './processErrors';

export default function handleErrorsFromLoadByUrl(error, dispatch) {
    const invalidSizeSmallErrorIndex = error.indexOf('change_avatar.invalid_image_size');
    const invalidSizeLargeErrorIndex = error.indexOf('change_avatar.invalid_file_size');
    const rateLimitExceededIndex = error.indexOf('rate.limit_exceeded');
    const errorArr = [...error];

    if (invalidSizeSmallErrorIndex !== -1) {
        errorArr[invalidSizeSmallErrorIndex] = 'change_avatar.by_url.invalid_image_size';
    }
    if (invalidSizeLargeErrorIndex !== -1) {
        errorArr[invalidSizeLargeErrorIndex] = 'change_avatar.by_url.invalid_file_size';
    }
    if (rateLimitExceededIndex !== -1) {
        errorArr[rateLimitExceededIndex] = 'rate.limit_exceeded.by_url';
    }
    dispatch(setAvatarError(processErrors(errorArr)));
}
