export default function processErrors(error) {
    const errorList = {
        'change_avatar.invalid_file_size': 'error-file.size',
        'change_avatar.by_url.invalid_file_size': 'error-url.file.size',
        'change_avatar.invalid_image_size': 'error-image.size',
        'change_avatar.by_url.invalid_image_size': 'error-url.image_size',
        'url.empty': 'error-url.empty',
        'file.invalid': 'error-file.invalid',
        'change_avatar.invalid_url': 'error-url.invalid',
        'rate.limit_exceeded': 'error-limit.file',
        'rate.limit_exceeded.by_url': 'error-limit',
        'exception.unhandled': 'error-internal',
        'change_avatar.invalid_yapic_response': 'error-internal',
        'change_avatar.mds_temporary_error': 'error-internal',
        'url.invalid': 'error-url.invalid'
    };

    return Array.isArray(error) && error.length > 0 ? errorList[error[0]] : errorList['exception.unhandled'];
}
