import {UPDATE_AVATAR, SET_AVATAR_ERROR, SET_AVATAR_STATUS, UPDATE_IMAGE_OPTIONS} from './actions';

const initialState = {
    track_id: undefined,
    url: null,
    backupAvatar: {
        url: ''
    },
    hasChanged: false,
    isDeletePossible: false,
    isByUrl: false,
    loadUrlPath: '',
    status: 'normal',
    type: 'jpeg',
    error: ''
};

export default function changeAvatar(state = initialState, action = {}) {
    switch (action.type) {
        case UPDATE_AVATAR:
            return $.extend({}, state, {
                track_id: action.data.track_id,
                hasChanged: action.data.hasChanged || false,
                url: action.data.avatarUrl,
                backupAvatar: action.data.backupAvatar || state.backupAvatar,
                isByUrl: action.data.isByUrl,
                queryUid: action.data.queryUid,
                loadUrlPath: action.data.loadUrlPath,
                isDeletePossible: action.data.isDeletePossible || false
            });
        case SET_AVATAR_ERROR:
            return $.extend({}, state, {
                error: action.error,
                hasChanged: false
            });
        case UPDATE_IMAGE_OPTIONS:
            return $.extend({}, state, {
                type: action.data.type,
                compression: action.data.compression
            });
        case SET_AVATAR_STATUS:
            return $.extend({}, state, {
                status: action.status
            });
        default: {
            return state;
        }
    }
}
