import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';
import {Money, Cards} from '../../';

export class BillingInfo extends Component {
    render() {
        const {dispatch, yamoney, retpath, billing, edit, settings} = this.props;
        const {tld} = settings;
        const {sum} = yamoney;

        return (
            <div className='section billing-info'>
                <span className='section-icon' />
                <div className='section-head'>
                    <h2 className='section-title'>
                        {sum !== undefined ? (
                            <span>
                                {`${i18n('Profile.money.title.sum', sum)} `}
                                <span className='money-rub'>Р</span>
                            </span>
                        ) : (
                            i18n('Profile.money.title.withoutsum')
                        )}
                    </h2>
                </div>
                {Boolean(tld === 'ru' || tld === 'ua') && (
                    <Cards dispatch={dispatch} billing={billing} settings={settings} retpath={retpath} edit={edit} />
                )}
                <Money {...this.props} />
                <Spin size='s' progress={Boolean(yamoney.progress || billing.progress)} />
            </div>
        );
    }
}

BillingInfo.propTypes = {
    dispatch: PropTypes.func.isRequired,
    billing: PropTypes.shape({
        progress: PropTypes.bool
    }),
    retpath: PropTypes.string,
    yamoney: PropTypes.shape({
        sum: PropTypes.string,
        progress: PropTypes.bool
    }),
    settings: PropTypes.shape({
        env: PropTypes.object,
        tld: PropTypes.string
    }),
    edit: PropTypes.string
};
