import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import {YandexAppPromo} from '@yandex-id/components';

import './Bonus.styl';

const cnBonus = cn('Bonus');

export class Bonus extends Component {
    render() {
        return (
            <YandexAppPromo
                className={cnBonus()}
                usrImg={this.props.usrImg}
                device={this.device}
                description={i18n('Profile2.bonus.description')}
                title={i18n('Profile2.bonus.title')}
                installMessage={this.installMessage}
                lang={this.props.lang}
            />
        );
    }

    get installMessage() {
        return this.props.isYandexApp ? i18n('Profile2.bonus.updateYandex') : i18n('Profile2.bonus.installYandex');
    }

    get device() {
        switch (this.props.osFamily) {
            case 'iOS':
                return 'ios';
            case 'Android':
                return 'android';
            default:
                return 'desktop';
        }
    }
}

Bonus.propTypes = {
    usrImg: PropTypes.string,
    osFamily: PropTypes.string,
    lang: PropTypes.string,
    isYandexApp: PropTypes.bool
};
