import {connect} from 'react-redux';

import {Bonus} from './Bonus';

const mapStateToProps = function(state = {}) {
    const {settings = {}, person = {}} = state;

    return {
        usrImg:
            settings.avatar &&
            settings.avatar.avatar_300 &&
            settings.avatar.avatar_300.replace('%avatar_id%', person.avatarId),
        osFamily: settings.ua && settings.ua.OSFamily,
        lang: person.language,
        isYandexApp: Boolean(settings.ua && settings.ua.BrowserName === 'YandexSearch')
    };
};

const ConnectedBonus = connect(mapStateToProps)(Bonus);

export {ConnectedBonus as Bonus};
