export const SET_CARDS_INFO = 'SET_CARDS_INFO';
export const SET_CARDS_INFO_PROGRESS_STATE = 'SET_CARDS_INFO_PROGRESS_STATE';
export const SET_CARDS_BIND_PROGRESS_STATE = 'SET_CARDS_BIND_PROGRESS_STATE';
export const SET_UNBIND_CARD = 'SET_UNBIND_CARD';
export const SELECT_CARD = 'SELECT_CARD';
export const SET_ERRORS = 'SET_ERRORS';
export const SET_FRAME_DATA = 'SET_FRAME_DATA';
export const SET_FRAME_VISIBLE_STATE = 'SET_FRAME_VISIBLE_STATE';
export const SET_TOKEN = 'SET_TOKEN';
export const CLEAR_BILLING_DATA = 'CLEAR_BILLING_DATA';
export const SET_ABORT_BILLING_STATE = 'SET_ABORT_BILLING_STATE';

export const clearBillingData = () => ({
    type: CLEAR_BILLING_DATA
});

export function setCardsInfo(cards) {
    return {
        type: SET_CARDS_INFO,
        cards
    };
}

export function setCardsInfoProgressState(progress) {
    return {
        type: SET_CARDS_INFO_PROGRESS_STATE,
        progress
    };
}

export function setCardsBindProgressState(progress) {
    return {
        type: SET_CARDS_BIND_PROGRESS_STATE,
        progress
    };
}

export function setUnbindCard(id) {
    return {
        type: SET_UNBIND_CARD,
        id
    };
}

export function selectCard(id) {
    return {
        type: SELECT_CARD,
        id
    };
}

export function setErrors(errors) {
    return {
        type: SET_ERRORS,
        errors
    };
}

export function setFrameData(params) {
    return {
        type: SET_FRAME_DATA,
        url: params.url,
        origin: params.origin
    };
}

export function setFrameVisibleState(visible) {
    return {
        type: SET_FRAME_VISIBLE_STATE,
        visible
    };
}

export function setToken(token) {
    return {
        type: SET_TOKEN,
        token
    };
}

export function setAbortBillingState(isAbort) {
    return {
        type: SET_ABORT_BILLING_STATE,
        isAbort
    };
}
