import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {splitCardNumber, EDIT_MODE_NAME, CARDS_LINK} from './';
import {selectCard} from './actions';
import {setEditMode} from '@blocks/common/actions';
import {push} from 'connected-react-router';
import metrics from '@blocks/metrics.js';
import {BILLING_METRICS_PREFIX, BILLING_GOAL_PREFIX} from '@blocks/morda/billing_info';

class Card extends PureComponent {
    constructor(props) {
        super(props);

        this.displayName = 'Card';
        this.selectCard = this.selectCard.bind(this);
    }

    selectCard() {
        const {isStatic, dispatch, card = {}, settings = {}} = this.props;
        const {isMobile, isTouch, isTablet} = settings.ua;
        const isPhone = (isMobile || isTouch) && !isTablet;

        if (!isStatic && dispatch) {
            metrics.send([BILLING_METRICS_PREFIX, 'Редактировать']);
            metrics.goal(`${BILLING_GOAL_PREFIX}edit`);

            if (isPhone) {
                dispatch(push(CARDS_LINK));
            } else {
                dispatch(selectCard(card.id));
                dispatch(setEditMode(EDIT_MODE_NAME));
                metrics.send([BILLING_METRICS_PREFIX, 'Открыли попап']);
            }
        }
    }

    render() {
        const {card = {}} = this.props;
        const {number = ''} = card;
        const system = (card.system || '').toLowerCase();
        const cls = system === 'mir' ? 'card-system-mir' : `card-system card-system-${system}`;

        return (
            <div className='card' onClick={this.selectCard}>
                <span className={cls} />
                {Boolean(number) && (
                    <span className='card-number'>
                        {splitCardNumber(number.length === 14 ? number.replace('****', '******') : number)}
                    </span>
                )}
            </div>
        );
    }
}

Card.propTypes = {
    card: PropTypes.shape({
        number: PropTypes.string.isRequired,
        system: PropTypes.string.isRequired,
        id: PropTypes.string.isRequired
    }),
    settings: PropTypes.shape({
        ua: PropTypes.shape({
            isMobile: PropTypes.bool,
            isTouch: PropTypes.bool,
            isTablet: PropTypes.bool
        })
    }),
    isStatic: PropTypes.bool,
    dispatch: PropTypes.func
};

export default Card;
