import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import {UnbindIcon} from './unbind_icon';

import './card_unbind.styl';

const b = cn('CardUnbind');

export class CardUnbind extends React.Component {
    getTitle = () => {
        const {hasPlus, isOneBindedCard} = this.props;

        if (hasPlus && isOneBindedCard) {
            return i18n('Profile.cards.unbind.title');
        }
        return i18n('Profile.cards.unbind.title.other');
    };
    getText = () => {
        const {hasPlus, isOneBindedCard} = this.props;

        if (hasPlus && isOneBindedCard) {
            return i18n('Profile.cards.unbind.text');
        }
        return i18n('Profile.cards.unbind.text.other');
    };

    onUnbindClick = () => {
        const {onUnbindClick, closeModal} = this.props;

        onUnbindClick();
        closeModal();
    };
    onSaveClick = () => {
        const {onSaveClick, closeModal} = this.props;

        onSaveClick();
        closeModal();
    };

    render() {
        const {hasPlus} = this.props;

        return (
            <div className={b()}>
                <div className={b('img', {hasPlus})} />
                <div className={b('title')}>{this.getTitle()}</div>
                <div className={b('text')}>{this.getText()}</div>
                <div className={b('buttons')}>
                    <div className={b('save')}>
                        <Button view='action' size='l' width='max' onClick={this.onSaveClick}>
                            {i18n('Profile.cards.unbind.save')}
                        </Button>
                    </div>
                    <div className={b('unbind')}>
                        <Button view='clear' size='l' width='max' onClick={this.onUnbindClick} iconLeft={UnbindIcon}>
                            {i18n('Profile.common.delete')}
                        </Button>
                    </div>
                </div>
            </div>
        );
    }
}

CardUnbind.propTypes = {
    hasPlus: PropTypes.bool.isRequired,
    isOneBindedCard: PropTypes.bool.isRequired,
    onSaveClick: PropTypes.func.isRequired,
    closeModal: PropTypes.func.isRequired,
    onUnbindClick: PropTypes.func.isRequired
};
