import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {CardsList} from './cards_list';
import {CardsForm} from './cards_form';
import {clearBillingData} from './actions';
import './cards_control.styl';

const b = cn('CardsControl');

class CardsControl extends React.Component {
    componentWillUnmount() {
        this.props.dispatch(clearBillingData());
    }

    render() {
        const {modal, dispatch, common = {}, retpath, billing, settings} = this.props;
        const {isFrameVisible, frameUrl} = billing;

        return (
            <div className={`${b({noPadding: isFrameVisible})} p-control-form`}>
                {Boolean(frameUrl) && <CardsForm dispatch={dispatch} modal={modal} />}

                {Boolean(!isFrameVisible) && (
                    <CardsList
                        dispatch={dispatch}
                        billing={billing}
                        settings={settings}
                        common={common}
                        retpath={retpath || common.retpath}
                        modal={modal}
                    />
                )}
            </div>
        );
    }
}

CardsControl.propTypes = {
    modal: PropTypes.bool,
    retpath: PropTypes.string,
    common: PropTypes.object,
    billing: PropTypes.shape({
        isBindingInProcess: PropTypes.bool,
        isFrameVisible: PropTypes.bool,
        frameUrl: PropTypes.string
    }).isRequired,
    dispatch: PropTypes.func.isRequired,
    settings: PropTypes.object
};

export default CardsControl;
