import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {TrustApi} from './';

const FRAME_WRAP_ID = 'cards-binding-form-wrap';

class CardsForm extends Component {
    constructor(props) {
        super(props);

        this.displayName = 'CardsForm';
    }

    componentDidMount() {
        const {dispatch, isTesting, lang, frameUrl} = this.props;

        this.api = new TrustApi(dispatch, lang, isTesting, `#${FRAME_WRAP_ID}`, frameUrl);
    }

    componentWillUnmount() {
        this.api.destroy();
    }

    render() {
        const {isFrameVisible} = this.props;

        return (
            <div className={`cards-binding-form-wrap ${isFrameVisible ? '' : 'g-hidden'}`} id={FRAME_WRAP_ID}>
                <div className='section-head'>
                    <h2 className='section-title'>{i18n('Profile.cards.bind.title')}</h2>
                </div>
            </div>
        );
    }
}

CardsForm.propTypes = {
    frameUrl: PropTypes.string.isRequired,
    isFrameVisible: PropTypes.bool,
    isTesting: PropTypes.bool.isRequired,
    lang: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired,
    modal: PropTypes.bool
};

export default CardsForm;
