import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {CardsList as CardsListComponent} from './cards_list.jsx';

const mapStateToProps = (state) => {
    const {modal, common = {}, retpath, billing, settings, dashboard, phones = {}} = state;
    const {restore = []} = phones;
    const {plus: {enabled: hasPlus = false} = {}} = dashboard;
    const {uid} = common;
    const hasRestorePhone = Boolean(restore.length);

    return {
        isUnbindCardAlertExp: hasExp(state, 'card_deletion_alert_exp'),
        hasPlus,
        billing,
        settings,
        modal,
        retpath: retpath || common.retpath,
        uid,
        hasRestorePhone
    };
};

export const CardsList = connect(mapStateToProps)(CardsListComponent);
