import {
    SET_CARDS_INFO,
    SET_CARDS_INFO_PROGRESS_STATE,
    SET_CARDS_BIND_PROGRESS_STATE,
    SET_UNBIND_CARD,
    SELECT_CARD,
    SET_ERRORS,
    SET_FRAME_DATA,
    CLEAR_BILLING_DATA,
    SET_FRAME_VISIBLE_STATE,
    SET_TOKEN,
    SET_ABORT_BILLING_STATE
} from './actions';

const defaultState = {
    cards: [],
    progress: false,
    bindProgress: false,
    unbindCardId: '',
    selected: '',
    errors: [],
    isFrameVisible: false,
    frameUrl: '',
    frameOrigin: '',
    isUpdated: false,
    token: '',
    isAbort: false
};

export default function cards(state = defaultState, action = {}) {
    switch (action.type) {
        case SET_CARDS_INFO:
            return Object.assign({}, state, {
                cards: action.cards.map((card) =>
                    Object.assign({}, card, {
                        number: card.number || '',
                        name: card.name || '',
                        system: card.system || '',
                        proto: card.proto || ''
                    })
                ),
                progress: false
            });
        case SET_CARDS_INFO_PROGRESS_STATE:
            return Object.assign({}, state, {
                progress: action.progress
            });
        case SET_CARDS_BIND_PROGRESS_STATE:
            return Object.assign({}, state, {
                bindProgress: action.progress
            });
        case SET_UNBIND_CARD:
            return Object.assign({}, state, {
                unbindCardId: action.id
            });
        case SELECT_CARD:
            return Object.assign({}, state, {
                selected: action.id
            });
        case SET_ERRORS:
            return Object.assign({}, state, {
                errors: action.errors
            });
        case SET_FRAME_DATA:
            return Object.assign({}, state, {
                frameUrl: action.url,
                frameOrigin: action.origin
            });
        case SET_FRAME_VISIBLE_STATE:
            return Object.assign({}, state, {
                isFrameVisible: action.visible
            });
        case SET_TOKEN:
            return Object.assign({}, state, {
                token: action.token
            });
        case CLEAR_BILLING_DATA:
            return Object.assign({}, defaultState, {
                cards: state.cards || defaultState.cards,
                errors: state.errors || defaultState.errors,
                progress: state.progress,
                lastClear: Number(new Date())
            });
        case SET_ABORT_BILLING_STATE:
            return Object.assign({}, state, {
                isAbort: action.isAbort
            });
        default:
            return state;
    }
}
