import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {Link} from 'react-router-dom';
import {setEditMode} from '@blocks/common/actions';
import metrics from '@blocks/metrics';
import AvatarContainer from '@blocks/morda/avatar/avatar-container.jsx';

export class Avatar extends Component {
    constructor(props) {
        super(props);

        this.showAvatarModal = this.showAvatarModal.bind(this);
    }

    sendMetrics() {
        metrics.send(['Сменить аватар (фотоаппарат)']);
        metrics.goal('profile_page_avatar_change');
    }

    showAvatarModal() {
        this.props.dispatch(setEditMode('edit-avatar'));
    }

    render() {
        const {paths, isPhone, settings, avatarId, login, children} = this.props;
        const {env} = settings;
        const isIntranet = env.name === 'intranet';
        const noAvatarPhone = Boolean(this.props.avatarId === '0/0-0') && isPhone;
        const iconClass = 'avatar-change show-icon';
        const changeAvatarLink = '/profile/avatars';
        const avatarPath = paths.pathname
            .replace('%uid%', avatarId)
            .replace('%login%', login)
            .replace('%size%', '200');
        const avatarStyle = {
            backgroundImage: `url("//${paths.host}${avatarPath}")`
        };

        return (
            <span className={classnames('avatar', {'no-avatar': noAvatarPhone})} style={avatarStyle}>
                <span className='avatar-mask' />
                {Boolean(!isIntranet) &&
                    (isPhone || isIntranet ? (
                        <span onTouchStart={this.sendMetrics}>
                            <Link className={iconClass} to={changeAvatarLink} />
                        </span>
                    ) : (
                        <span>
                            <span onMouseDown={this.sendMetrics} onClick={this.showAvatarModal} className={iconClass} />
                            <AvatarContainer />
                        </span>
                    ))}
                {children && <div onClick={this.showAvatarModal}>{children}</div>}
            </span>
        );
    }
}

Avatar.propTypes = {
    dispatch: PropTypes.func.isRequired,
    paths: PropTypes.shape({
        host: PropTypes.string,
        pathname: PropTypes.string,
        default_300: PropTypes.string
    }),
    login: PropTypes.string.isRequired,
    avatarId: PropTypes.string.isRequired,
    isPhone: PropTypes.bool,
    settings: PropTypes.shape({
        env: PropTypes.object
    }),
    children: PropTypes.node
};
