import React from 'react';
import {ControlWithErrors} from '@blocks/morda/components/control/control.jsx';
import {Input} from '@components/Input';
import {Select} from '@components/Select';

export class Birthday extends ControlWithErrors {
    constructor(props) {
        super(props);

        this.displayName = 'birthday';
        this.options = [
            {
                content: i18n('Profile.personal.data.birthday.month'),
                value: '00'
            },
            {
                content: i18n('Months.n1'),
                value: '01'
            },
            {
                content: i18n('Months.n2'),
                value: '02'
            },
            {
                content: i18n('Months.n3'),
                value: '03'
            },
            {
                content: i18n('Months.n4'),
                value: '04'
            },
            {
                content: i18n('Months.n5'),
                value: '05'
            },
            {
                content: i18n('Months.n6'),
                value: '06'
            },
            {
                content: i18n('Months.n7'),
                value: '07'
            },
            {
                content: i18n('Months.n8'),
                value: '08'
            },
            {
                content: i18n('Months.n9'),
                value: '09'
            },
            {
                content: i18n('Months.n10'),
                value: '10'
            },
            {
                content: i18n('Months.n11'),
                value: '11'
            },
            {
                content: i18n('Months.n12'),
                value: '12'
            }
        ];

        this.errors = {
            [this.displayName]: {
                invalid: i18n('Frontend.birthday_errors_invalid')
            }
        };

        this.onFieldChange = this.onFieldChange.bind(this);
        this.onChange = super.onChange.bind(this);
        this.getErrorView = super.getErrorView.bind(this);
        this.onSelectChange = this.onSelectChange.bind(this);
        this.getSelectView = this.getSelectView.bind(this);

        const _birthday = this.props.birthday || '';
        const birthday = _birthday.split('-') || [];

        this.state = {
            year: birthday[0] || '',
            month: birthday[1] || '00',
            day: birthday[2] || ''
        };
    }

    getRequestParams() {
        const year = this.state.year.trim() || '';
        const month = this.state.month.trim() || '';

        let day = this.state.day.trim() || '';

        if (day.length !== 2 && parseInt(day, 10) < 10) {
            day = `0${day}`;
        }

        let birthday = `${year}-${month}-${day}`;

        if (!day && !year && month === '00') {
            birthday = '';
        }

        return {
            birthday,
            passErrors: true
        };
    }

    getSelectView() {
        const month = this.state.month;

        return (
            <Select
                value={month}
                size='l'
                dataT='month'
                name='month'
                width='max'
                pin='clear-clear'
                onChange={this.onSelectChange}
                options={this.options}
            />
        );
    }

    onSelectChange(event) {
        this.setState({month: event.target.value});
    }

    onFieldChange(event) {
        const {target = {}} = event;
        const {value, name} = target;
        const fieldName = name.replace('birthday-', '');

        this.setState({[fieldName]: value});
        this.onChange();
    }

    getEntryView() {
        return (
            <div className='p-control-entry'>
                <div className='control-group control-group__birthday'>
                    <span className='personal-info-birthday-day' data-t='personal-info-birthday-day'>
                        <Input
                            size='l'
                            id='birthday-day'
                            name='birthday-day'
                            type='text'
                            value={this.state.day}
                            placeholder={i18n('Profile.personal.data.birthday.day')}
                            autoComplete='off'
                            maxLength='2'
                            onChange={this.onFieldChange}
                            pin='round-brick'
                        />
                    </span>

                    <span className='personal-info-birthday-month' data-t='personal-info-birthday-month'>
                        {this.getSelectView()}
                    </span>

                    <span className='personal-info-birthday-year' data-t='personal-info-birthday-year'>
                        <Input
                            size='l'
                            id='birthday-year'
                            name='birthday-year'
                            type='text'
                            value={this.state.year}
                            placeholder={i18n('Profile.personal.data.birthday.year')}
                            autoComplete='off'
                            maxLength='4'
                            onChange={this.onFieldChange}
                            pin='brick-round'
                        />
                    </span>
                </div>

                <span data-t='personal-info-birthday-error'>{this.getErrorView()}</span>
            </div>
        );
    }
}

Birthday.defaultProps = {
    label: i18n('Profile.personal.data.birthday')
};
