import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';
import {Modal} from '@components/Modal';
import {showRegPopup, setEditMode} from '@blocks/common/actions';
import metrics from '@blocks/metrics';

const PASSWORD_URL = '/profile/password?origin=passport_profile';
const CHANGE_PASSWORD_EDIT_MODE = 'changePasswordError';

export class ChangePassword extends Component {
    constructor() {
        super();
        this.closeErrorModal = this.closeErrorModal.bind(this);
        this.changePassword = this.changePassword.bind(this);
    }

    closeErrorModal() {
        this.props.dispatch(setEditMode(null));
    }

    sendMetrics() {
        metrics.send(['Сменить пароль']);
    }

    changePassword() {
        const {passwordStrength, canChangePassword, dispatch} = this.props;

        if (canChangePassword !== undefined && !canChangePassword) {
            dispatch(setEditMode(CHANGE_PASSWORD_EDIT_MODE));
        } else if (passwordStrength === -1) {
            dispatch(showRegPopup(true));
        } else {
            window.location.href = PASSWORD_URL;
        }
    }

    render() {
        const isModalOpen = this.props.setEditMode === CHANGE_PASSWORD_EDIT_MODE;

        return (
            <span>
                <span onMouseDown={this.sendMetrics}>
                    <Link pseudo={true} onClick={this.changePassword}>
                        {i18n('_AUTH_.changePassword')}
                    </Link>
                </span>
                <Modal
                    visible={isModalOpen}
                    zIndexGroupLevel={-0.5}
                    onCloserClick={this.closeErrorModal}
                    dataT='change-password'
                >
                    <div className='section-head'>
                        <h2 className='section-title'>{i18n('Errors.password.change.forbidden')}</h2>
                    </div>
                    <div className='p-control-modal-message'>{i18n('_AUTH_.restore_domain_not_served')}</div>
                </Modal>
            </span>
        );
    }
}

ChangePassword.propTypes = {
    dispatch: PropTypes.func.isRequired,
    passwordStrength: PropTypes.number.isRequired,
    canChangePassword: PropTypes.bool,
    setEditMode: PropTypes.string
};
