import React from 'react';
import {ControlWithErrors} from '@blocks/morda/components/control/control.jsx';
import {Input} from '@components/Input';

export class City extends ControlWithErrors {
    constructor(props) {
        super(props);

        this.displayName = 'city';
        this.errors = {
            [this.displayName]: {
                invalid: i18n('Frontend.registration_city_errors_invalid')
            }
        };

        this.state = {
            city: this.props.city || ''
        };

        this.changeCity = this.changeCity.bind(this);
        this.onChange = super.onChange.bind(this);
        this.getErrorView = super.getErrorView.bind(this);
    }

    getRequestParams() {
        return {
            city: this.state.city || '',
            passErrors: true
        };
    }

    changeCity(event) {
        const {target = {}} = event;
        const {value} = target;

        this.setState({city: value});
        this.onChange();
    }

    getEntryView() {
        return (
            <div className='p-control-entry'>
                <div className='p-control-entry-cntrl' data-t='personal-info-city'>
                    <Input
                        size='l'
                        id={this.displayName}
                        name={this.displayName}
                        type='text'
                        value={this.state.city}
                        placeholder={this.props.placeholder}
                        autoComplete='off'
                        onChange={this.changeCity}
                    />

                    {this.getErrorView()}
                </div>
            </div>
        );
    }
}

City.defaultProps = {
    label: i18n('Profile.personal.city'),
    placeholder: i18n('Profile.personal.city')
};
