import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {clearPersonalInfoFieldErrors} from '@blocks/morda/personal_info/actions';

export class Control extends Component {
    /**
     * Returns request params for fetch functions
     *
     * @return {object} request params
     */
    getRequestParams() {
        return {
            [this.props.field || this.displayName]: this.getVal(),
            passErrors: true
        };
    }

    /**
     * Returns value of bem-component
     *
     * @return {string} value
     */
    getVal() {
        const entry = this.refs.entry;

        return entry && typeof entry.value === 'function' ? entry.value().trim() : entry ? entry.value : '';
    }

    /**
     * Returns current component entry from store.
     * Override it!
     *
     * @return {string} current component entry
     */
    getEntry() {
        return '';
    }

    /**
     * Set field value from props
     * Override it!
     *
     * @return {void}
     */
    setValueFromProps() {} // eslint-disable-line no-empty-function

    onChange() {} // eslint-disable-line no-empty-function

    /**
     * View
     *
     * @return {void}
     */
    getControlWrapperClassName() {
        return `p-control p-control-${this.displayName ? this.displayName : this.props.field}`;
    }

    getLabelView() {
        if (!this.props.label) {
            return <div className='p-control-label' />;
        }

        return <div className='p-control-label'>{this.props.label}:</div>;
    }

    getEntryView() {} // eslint-disable-line no-empty-function

    getControl() {
        return (
            <div className={this.getControlWrapperClassName.bind(this)()}>
                {this.getLabelView.bind(this)()}
                {this.getEntryView.bind(this)()}
            </div>
        );
    }

    render() {
        return this.getControl();
    }
}

Control.propTypes = {
    field: PropTypes.string.isRequired,
    label: PropTypes.string
};

const defaultErros = {
    internal: i18n('Errors.ErrorsTexts.internal')
};

export class ControlWithErrors extends Control {
    onChange() {
        const {field, dispatch} = this.props;

        dispatch(clearPersonalInfoFieldErrors(field || this.displayName));
    }

    getErrorView(options = {}) {
        const {errors = {}, field} = this.props;
        const fieldName = options.field || field || this.displayName;

        let error = '';

        if (errors[fieldName]) {
            error =
                (this.errors && this.errors[fieldName] && this.errors[fieldName][errors[fieldName]]) ||
                defaultErros.internal;
        }

        if (!error) {
            return null;
        }

        return <div className='p-control-error-block'>{error}</div>;
    }

    getEntryView() {
        /* eslint-disable no-useless-call */
        return (
            <span>
                {super.getEntryView.call(this)}
                {this.getErrorView.call(this)}
            </span>
        );
        /* eslint-enable no-useless-call */
    }
}

ControlWithErrors.propTypes = {
    field: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired
};
