import React from 'react';
import PropTypes from 'prop-types';
import {Control} from '@blocks/morda/components/control/control.jsx';
import {Spin} from '@components/Spin';
import getCountries from '@blocks/common/actions/getCountries';
import {Select} from '@components/Select';

export class Country extends Control {
    constructor(props) {
        super(props);

        this.displayName = 'country';
        this.getSelectView = this.getSelectView.bind(this);
        this.changeCountry = this.changeCountry.bind(this);

        this.state = {
            country: this.props.country || ''
        };
    }

    componentDidMount() {
        if (this.props.countries) {
            return;
        }

        const lang = this.props.settings && this.props.settings.language;

        this.props.dispatch(getCountries(lang));
    }

    changeCountry(event) {
        this.setState({country: event.target.value});
    }

    getRequestParams() {
        return {
            country: this.state.country || '',
            passErrors: true
        };
    }

    getOptions = () => {
        return this.props.countries.map((item) => ({
            value: item.iso,
            content: item.name
        }));
    };

    getSelectView() {
        const country = this.state.country || '';

        if (!this.props.countries) {
            return null;
        }

        return (
            <Select
                value={country}
                size='l'
                dataT='country'
                name='country'
                width='max'
                onChange={this.changeCountry}
                options={this.getOptions()}
            />
        );
    }

    getEntryView() {
        return (
            <div className='p-control-entry'>
                <div className='p-control-entry-cntrl personal-info-country' data-t='personal-info-country'>
                    {this.props.countries ? this.getSelectView() : <Spin size='s' progress={true} />}
                </div>
            </div>
        );
    }
}

Country.defaultProps = {
    label: i18n('Profile.personal.data.region')
};

Country.propTypes = {
    countries: PropTypes.array
};
