import React, {Component} from 'react';
import {Link} from '@components/Link';
import metrics from '@blocks/metrics.js';

export class DeleteAccount extends Component {
    constructor(props) {
        super(props);
        this.sendMetrics = this.sendMetrics.bind(this);
    }

    shouldComponentUpdate() {
        return false;
    }

    sendMetrics() {
        metrics.send('Другие настройки: Удалить аккаунт');
    }

    render() {
        return (
            <div className='p-control-link'>
                <span onMouseDown={this.sendMetrics}>
                    <Link href='/passport?mode=delete&origin=passport_profile'>
                        {i18n('Profile.personal.hangover.remove')}
                    </Link>
                </span>
            </div>
        );
    }
}
