import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';
import {CHECK_HUMAN, CHECK_HUMAN_FAIL, CHECK_HUMAN_SUCCESS} from '@blocks/morda/components/domik/actions';
import api from '@blocks/api';

export function checkHuman(data) {
    return function(dispatch, getState) {
        const state = getState();
        const common = state.common;
        const {errors} = state.domik;
        const actionForRepeat = common.actionForRepeat || {};
        const {action, payload} = actionForRepeat;

        data.csrf_token = common.csrf; // eslint-disable-line
        data.track_id = common.track_id; // eslint-disable-line

        if (Object.keys(errors).length !== 0) {
            return;
        }
        if ('captcha' in data) {
            data.key = state.captcha.key; // eslint-disable-line
            data.answer = data.captcha; // eslint-disable-line
            delete data.captcha; // eslint-disable-line

            dispatch(reloadCaptcha());
        }
        dispatch({
            type: CHECK_HUMAN
        });
        api.request('checkHuman', data)
            .done(() => {
                dispatch({
                    type: CHECK_HUMAN_SUCCESS
                });
                if (action) {
                    dispatch(action(...payload));
                }
            })
            .fail((res) => {
                dispatch({
                    type: CHECK_HUMAN_FAIL,
                    res
                });
            });
    };
}
