import React from 'react';
import {Control} from '@blocks/morda/components/control/control.jsx';
import {RadioButton} from '@components/RadioButton';

const name = 'gender';

export class Gender extends Control {
    constructor(props) {
        super(props);

        this.displayName = name;
        this.options = [
            {
                children: i18n('Profile.personal.data.gender.male'),
                value: 1,
                'data-t': 'radiobutton:gender:male'
            },
            {
                children: i18n('Profile.personal.data.gender.female'),
                value: 2,
                'data-t': 'radiobutton:gender:female'
            }
        ];

        this.onFieldChange = this.onFieldChange.bind(this);

        this.state = {
            gender: this.props.gender || ''
        };
    }

    onFieldChange(event) {
        this.setState({gender: parseInt(event.target.value, 10)});
    }

    getRequestParams() {
        return {
            gender: this.state.gender || 0,
            passErrors: true
        };
    }

    getEntryView() {
        return (
            <span data-t='personal-info-gender'>
                <RadioButton
                    width='max'
                    value={this.state.gender}
                    options={this.options}
                    onChange={this.onFieldChange}
                />
            </span>
        );
    }
}

Gender.defaultProps = {
    label: i18n('Profile.personal.data.gender')
};
