import React from 'react';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';
import {Modal} from '@components/Modal';
import {Button} from '@components/Button';
import metrics from '@blocks/metrics';
import {setEditMode} from '@blocks/common/actions';

const GLOBAL_LOGOUT_LINK = '/passport?origin=passport_profile&mode=logout&global=1&yu=';
const GLOBAL_LOGOUT_ERROR_MODAL = 'globalLogoutError';

export class GlobalLogout extends React.Component {
    constructor(props) {
        super(props);

        this.showAlert = this.showAlert.bind(this);
        this.closeAlert = this.closeAlert.bind(this);
    }

    closeAlert() {
        this.props.dispatch(setEditMode(null));
    }

    showAlert() {
        this.props.dispatch(setEditMode(GLOBAL_LOGOUT_ERROR_MODAL));
    }

    sendMetrics(msg) {
        metrics.send(['Выйти на всех устройствах', msg]);
    }

    getGlogoutMessage() {
        return {
            __html: this.props.isIntranet
                ? i18n('Profile.globallogout.alert.message.yandexteam')
                : i18n('Profile.globallogout.alert.message')
        };
    }

    render() {
        const glogoutLink = `${GLOBAL_LOGOUT_LINK}${this.props.yandexuid}`;

        return (
            <div>
                <span onMouseDown={() => this.sendMetrics('Открыть форму')}>
                    <Link pseudo={true} href={glogoutLink} onClick={this.showAlert}>
                        {i18n('Profile.globallogout.link')}
                    </Link>
                </span>
                <Modal visible={this.props.setEditMode === GLOBAL_LOGOUT_ERROR_MODAL} dataT='global-logout'>
                    <div className='p-control-modal'>
                        <div className='section-head'>
                            <h2 className='section-title'>{i18n('Profile.globallogout.alert.title')}</h2>
                        </div>
                        <div className='p-control-modal-message' dangerouslySetInnerHTML={this.getGlogoutMessage()} />
                        <div className='p-control-saveblock'>
                            <div className='p-control-saveblock-cell-right'>
                                <span
                                    onMouseDown={() => this.sendMetrics('Подтвердить')}
                                    className='p-control-saveblock-button'
                                >
                                    <Button size='l' type='link' view='action' url={glogoutLink}>
                                        {i18n('Frontend.confirm.operation')}
                                    </Button>
                                </span>
                            </div>
                            <div className='p-control-saveblock-cell-left'>
                                <span
                                    onMouseDown={() => this.sendMetrics('Отменить')}
                                    className='p-control-saveblock-button'
                                >
                                    <Button size='l' view='pseudo' onClick={this.closeAlert}>
                                        {i18n('_AUTH_.cancel.operation')}
                                    </Button>
                                </span>
                            </div>
                        </div>
                    </div>
                </Modal>
            </div>
        );
    }
}

GlobalLogout.propTypes = {
    dispatch: PropTypes.func.isRequired,
    isIntranet: PropTypes.bool.isRequired,
    yandexuid: PropTypes.string.isRequired,
    setEditMode: PropTypes.string
};
