import React, {Component} from 'react';
import PropTypes from 'prop-types';

class Account extends Component {
    getChangeDefaultUrl() {
        const {changeDefaultUrl, uid} = this.props;

        return changeDefaultUrl ? `${changeDefaultUrl}&uid=${uid}` : '';
    }

    render() {
        const {mail, login, name, avatarId, avatarPath} = this.props;
        const avatar = avatarPath.replace('%uid%', avatarId);
        const displayName = mail || login || name || '';
        const href = this.getChangeDefaultUrl();
        const avatarStyle = {
            backgroundImage: `url("//${avatar}")`
        };

        return (
            <li>
                {Boolean(displayName) && (
                    <a className='header-account' href={href}>
                        <span className='header-account-avatar' style={avatarStyle} />
                        <span className='header-account-name__firstletter'>{displayName.charAt(0)}</span>
                        {displayName.substr(1)}
                    </a>
                )}
            </li>
        );
    }
}

Account.propTypes = {
    mail: PropTypes.string,
    login: PropTypes.string.isRequired,
    avatarId: PropTypes.string.isRequired,
    avatarPath: PropTypes.string.isRequired,
    name: PropTypes.string,
    changeDefaultUrl: PropTypes.string.isRequired,
    uid: PropTypes.string.isRequired
};

export default Account;
