import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Menu} from '@components/Menu';
import Account from './account.jsx';

class Accounts extends Component {
    getChangeDefaultUrl() {
        const props = this.props;

        let changeDefaultUrl = props.embeddedauth.replace('%tld%', props.tld);

        ['action', 'yu', 'retpath'].forEach((key) => {
            changeDefaultUrl += '&';
            changeDefaultUrl += key;
            changeDefaultUrl += '=';

            if (key === 'action') {
                changeDefaultUrl += 'change_default';
            } else if (key === 'retpath') {
                changeDefaultUrl += encodeURIComponent(props.currentPage);
            } else {
                changeDefaultUrl += encodeURIComponent(props[key]) || '';
            }
        });

        return changeDefaultUrl;
    }

    getAddAccountView() {
        if (!this.props.canAddMore) {
            return '';
        }

        const href = `/auth?mode=add-user&retpath=${encodeURIComponent(this.props.currentPage)}`;

        return (
            <a className='header-account header-account__add' href={href}>
                <span className='header-account-avatar header-account-avatar__add' />
                {i18n('Frontend.multi_add_account')}
            </a>
        );
    }

    onItemClick = (event = {}) => {
        const {target = {}} = event;
        const {value} = target;

        if (typeof window !== 'undefined') {
            location.href = value;
        }
    };

    render() {
        const changeDefaultUrl = this.getChangeDefaultUrl();
        const {accounts, avatar, links, yu, retpath, currentPage, isIntranet} = this.props;
        const avatarPath = avatar.host + avatar.pathname.replace('%size%', 'small');
        const subMenuOptions = [
            {
                content: i18n('Frontend.tune'),
                value: links.tune
            },
            {
                content: i18n('Frontend.exit'),
                value: `/passport?mode=logout&yu=${yu}&retpath=${encodeURIComponent(retpath || currentPage)}`
            }
        ];

        if (isIntranet) {
            subMenuOptions.shift();
        }

        return (
            <div>
                <ul className='header-accounts'>
                    {Boolean(accounts && accounts.length > 1) &&
                        accounts.map((account) => (
                            <Account
                                mail={account.mail}
                                login={account.login}
                                avatarId={account.avatarId}
                                uid={account.uid}
                                avatarPath={avatarPath}
                                changeDefaultUrl={changeDefaultUrl}
                                key={account.uid}
                            />
                        ))}

                    {this.getAddAccountView()}
                </ul>
                <Menu size='s' width='max' items={subMenuOptions} onChange={this.onItemClick} />
            </div>
        );
    }
}

Accounts.propTypes = {
    accounts: PropTypes.arrayOf(PropTypes.object),
    avatar: PropTypes.shape({
        host: PropTypes.string.isRequired,
        pathname: PropTypes.string.isRequired
    }),
    links: PropTypes.objectOf(PropTypes.string),
    canAddMore: PropTypes.bool,
    isIntranet: PropTypes.bool,
    yu: PropTypes.string.isRequired,
    retpath: PropTypes.string,
    currentPage: PropTypes.string.isRequired,
    embeddedauth: PropTypes.string.isRequired,
    tld: PropTypes.string.isRequired
};

export default Accounts;
