import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import metrics from '@blocks/metrics.js';
import Link from '@blocks/morda/components/link/link.jsx';

class Logo extends Component {
    shouldComponentUpdate() {
        return false;
    }

    sendMetrics(msg) {
        metrics.send(['Шапка', msg]);
    }

    render() {
        const {language, links, reactLink} = this.props;
        const logoYandexClassName = classnames({
            'header-logo_yandex': true,
            'header-logo_yandex__ru': ['ru', 'uk'].indexOf(language) !== -1,
            'header-logo_yandex__en': ['ru', 'uk'].indexOf(language) === -1
        });
        const logoServiceClassName = classnames({
            'header-logo_service': true,
            'header-logo_service__ru': ['ru', 'uk'].indexOf(language) !== -1,
            'header-logo_service__en': ['ru', 'uk', 'tr'].indexOf(language) === -1,
            'header-logo_service__tr': language === 'tr'
        });

        return (
            <span>
                <a
                    href={links.yandex}
                    className={logoYandexClassName}
                    onMouseDown={() => this.sendMetrics('логотип Яндекса')}
                />
                <Link
                    url={'/profile'}
                    reactLink={reactLink}
                    className={logoServiceClassName}
                    onClick={() => this.sendMetrics('логотип Паспорта')}
                />
            </span>
        );
    }
}

Logo.propTypes = {
    language: PropTypes.string.isRequired,
    reactLink: PropTypes.bool,
    links: PropTypes.shape({
        yandex: PropTypes.string.isRequired
    }).isRequired
};

export default Logo;
