import {DEFAULT_AVATAR_ID} from '@blocks/avatar-displayname/avatarConsts';
import {
    UPDATE_HEADER_AVATAR,
    HEADER_SHOW_USER_DROPDOWN,
    HEADER_SHOW_SUB_NAVIGATION,
    HEADER_SET_DISPLAY_NAME
} from './actions';

export default function header(state = {}, action) {
    switch (action.type) {
        case UPDATE_HEADER_AVATAR: {
            const updated = Object.assign({}, state.defaultAccount, {avatarId: action.avatarId || DEFAULT_AVATAR_ID});
            const accounts = (state.accounts || []).slice();

            for (let i = 0; i < accounts.length; i++) {
                if (String(accounts[i].uid) === String(state.defaultAccount.uid)) {
                    accounts[i] = Object.assign({}, accounts[i], {
                        avatarId: action.avatarId
                    });

                    break;
                }
            }

            return Object.assign({}, state, {
                defaultAccount: updated,
                accounts
            });
        }
        case HEADER_SHOW_SUB_NAVIGATION: {
            return Object.assign({}, state, {
                showSubNavigation: action.show
            });
        }
        case HEADER_SHOW_USER_DROPDOWN: {
            return Object.assign({}, state, {
                showUserDropdown: action.show
            });
        }
        case HEADER_SET_DISPLAY_NAME: {
            return Object.assign({}, state, {
                defaultAccount: Object.assign({}, state.defaultAccount, {
                    displayName: action.displayName
                }),
                accounts: state.accounts.map((account) => {
                    if (String(account.uid) === action.uid) {
                        return Object.assign({}, account, {
                            displayName: action.displayName
                        });
                    }

                    return account;
                })
            });
        }
        default:
            return state;
    }
}
