import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Popup} from '@components/Popup';
import {Menu} from '@components/Menu';
import metrics from '@blocks/metrics.js';
import {showSubNavigation} from './actions';

class ServicesNavigation extends Component {
    moreRef = React.createRef();

    constructor(props) {
        super(props);

        this.onMoreMenuClick = this.onMoreMenuClick.bind(this);
        this.onOutsideMenuClick = this.onOutsideMenuClick.bind(this);
    }

    onMoreMenuClick(event) {
        event.preventDefault();

        this.props.dispatch(showSubNavigation(true));
    }

    onOutsideMenuClick() {
        this.props.dispatch(showSubNavigation(false));
    }

    getNavigation(items) {
        const links = this.props.links;
        const navigation = {
            mail: {content: i18n('Header.navigation.mail'), value: links.mail},
            maps: {content: i18n('Header.navigation.maps'), value: links.maps},
            market: {content: i18n('Header.navigation.market'), value: links.market},
            images: {content: i18n('Header.navigation.images'), value: links.images},
            video: {content: i18n('Header.navigation.video'), value: links.video},
            news: {content: i18n('Header.navigation.news'), value: links.news},
            pogoda: {content: i18n('Header.navigation.pogoda'), value: links.pogoda},
            browser: {content: i18n('Header.navigation.browser'), value: links.browser},
            music: {content: i18n('Header.navigation.music'), value: links.music},
            money: {content: i18n('Header.navigation.money'), value: links.money},
            rasp: {content: i18n('Header.navigation.rasp'), value: links.rasp},
            appmetrica: {content: i18n('Header.navigation.appmetrica'), value: links.appmetrica},
            translate: {content: i18n('Header.navigation.translate'), value: links.translate},
            all: {content: i18n('Header.navigation.all'), value: links.all},
            calendar: {content: i18n('Header.navigation.calendar'), value: links.calendar},
            disk: {content: i18n('Header.navigation.disk'), value: links.disk},
            tv: {content: i18n('Header.navigation.tv'), value: links.tv},
            afisha: {content: i18n('Header.navigation.afisha'), value: links.afisha},
            search: {content: i18n('Header.navigation.search'), value: links.search},
            portal: {content: i18n('Header.navigation.portal'), value: links.portal},
            yamb: {content: i18n('Header.navigation.yamb'), value: links.yamb},
            wiki: {content: i18n('Header.navigation.wiki'), value: links.wiki},
            meetingrooms: {content: i18n('Header.navigation.meetingrooms'), value: links.meetingrooms},
            st: {content: i18n('Header.navigation.st'), value: links.st},
            contacts: {content: i18n('Header.navigation.contacts'), value: links.contacts},
            golem: {content: i18n('Header.navigation.golem'), value: links.golem},
            staff: {content: i18n('Header.navigation.staff'), value: links.staff},
            abc: {content: i18n('Header.navigation.abc'), value: links.abc},
            at: {content: i18n('Header.navigation.at'), value: links.at},
            idm: {content: i18n('Header.navigation.idm'), value: links.idm},
            lib: {content: i18n('Header.navigation.lib'), value: links.lib},
            doc: {content: i18n('Header.navigation.doc'), value: links.doc},
            lego: {content: i18n('Header.navigation.lego'), value: links.lego},
            mag: {content: i18n('Header.navigation.mag'), value: links.mag},
            guide: {content: i18n('Header.navigation.guide'), value: links.guide},
            ml: {content: i18n('Header.navigation.ml'), value: links.ml},
            otrs: {content: i18n('Header.navigation.otrs'), value: links.otrs},
            stat: {content: i18n('Header.navigation.stat'), value: links.stat},
            jhist: {content: i18n('Header.navigation.jhist'), value: links.jhist}
        };

        return items.map((item) => navigation[item] || {});
    }

    getNavigationByTld() {
        const {tld, isWSUser, isIntranet} = this.props;
        const head = isWSUser ? ['portal', 'mail', 'yamb'] : ['mail'];

        let tail = [];

        switch (isIntranet) {
            case true:
                tail = [
                    'calendar',
                    'wiki',
                    'meetingrooms',
                    'st',
                    'contacts',
                    'golem',
                    'staff',
                    'abc',
                    'at',
                    'idm',
                    'lib',
                    'doc',
                    'lego',
                    'mag',
                    'guide',
                    'ml',
                    'otrs',
                    'stat',
                    'jhist'
                ];

                break;

            default:
                switch (tld) {
                    case 'ua':
                        tail = [
                            'calendar',
                            'disk',
                            'images',
                            'news',
                            'maps',
                            'market',
                            'pogoda',
                            'tv',
                            'music',
                            'afisha',
                            'browser',
                            'all'
                        ];

                        break;
                    case 'com.tr':
                        tail = ['disk', 'search', 'images', 'maps', 'browser', 'translate', 'pogoda', 'all'];

                        break;
                    case 'com':
                        tail = ['disk', 'search', 'images', 'maps', 'browser', 'translate'];

                        break;
                    default:
                        tail = ['calendar', 'disk', 'search', 'maps', 'browser', 'translate', 'pogoda', 'news'];

                        if (isWSUser) {
                            tail = [
                                'calendar',
                                'disk',
                                'images',
                                'news',
                                'maps',
                                'market',
                                'pogoda',
                                'tv',
                                'music',
                                'afisha',
                                'browser',
                                'all'
                            ];
                        }
                }
        }

        return this.getNavigation(head.concat(tail));
    }

    sendMetrics(msg) {
        metrics.send(`Шапка: ${msg}`);
    }

    onItemClick = (event = {}) => {
        const {target = {}} = event;
        const {value} = target;

        if (typeof window !== 'undefined') {
            location.href = value;
        }
    };

    render() {
        const {links, tld, showSubNavigation} = this.props;
        const navigation = this.getNavigationByTld();
        const limits = {
            ru: 4,
            com: 2,
            'com.tr': 2,
            ua: 3
        };

        const limit = limits[tld || 'ru'] || limits.ru;

        let mainNavigation = [];

        let subNavigation = [];

        if (navigation.length > 5) {
            mainNavigation = navigation.slice(0, limit);
            subNavigation = navigation.slice(limit);

            mainNavigation.push({
                content: i18n('Header.navigation.more'),
                value: links.all
            });
        } else {
            mainNavigation = navigation;
        }

        return (
            <span className='header-navigation'>
                {mainNavigation.map((item, index) => (
                    <a
                        href={item.value}
                        key={index}
                        ref={this.moreRef}
                        onClick={index === limit ? this.onMoreMenuClick : undefined}
                        onMouseDown={() => this.sendMetrics(item.value)}
                        className='header-navigation-item'
                    >
                        {item.content}
                    </a>
                ))}

                <Popup
                    target='anchor'
                    visible={showSubNavigation}
                    anchor={this.moreRef}
                    onOutsideClick={this.onOutsideMenuClick}
                    ignoreRefs={[this.moreRef]}
                >
                    <Menu size='s' width='max' items={subNavigation} onChange={this.onItemClick} />
                </Popup>
            </span>
        );
    }
}

ServicesNavigation.propTypes = {
    links: PropTypes.object.isRequired,
    isIntranet: PropTypes.bool.isRequired,
    isWSUser: PropTypes.bool,
    tld: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired,
    showSubNavigation: PropTypes.bool
};

export default ServicesNavigation;
