import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Link as LegoLink} from '@components/Link';
import {Link as ReactRouterLink} from 'react-router-dom';

const REACT_PAGES = {
    main: '/profile',
    personal: '/profile/personal-info',
    userQuestion: '/profile/change-hint',
    social: '/profile/social',
    socialProfile: '/profile/social/:profileId',
    address: '/profile/address',
    emails: '/profile/emails',
    emailsAdd: '/profile/emails/add',
    emailsList: '/profile/emails/list',
    cards: '/profile/cards',
    avatars: '/profile/avatars',
    select: '/restoration/select',
    login: '/restoration/login',
    appPasswordsList: '/profile/apppasswords-list',
    alice: '/profile/alice-settings'
};

export const LINK_CLASS_NAME = 'control link link_theme_normal';

class Link extends Component {
    render() {
        const {url, children, onClick, reactLink, className = ''} = this.props;

        let isReactPage = false;

        if (reactLink) {
            Object.keys(REACT_PAGES).forEach((routeName) => {
                if (url.indexOf(REACT_PAGES[routeName]) !== -1 && routeName !== 'main') {
                    isReactPage = true;
                } else if (url.match(/\/profile(\?|$)/) && routeName === 'main') {
                    isReactPage = true;
                }
            });
        }

        if (isReactPage) {
            return (
                <ReactRouterLink className={className || LINK_CLASS_NAME} onClick={onClick} to={url}>
                    {children}
                </ReactRouterLink>
            );
        }

        return (
            <LegoLink className={className} href={url} onClick={onClick}>
                {children}
            </LegoLink>
        );
    }
}

Link.defaultProps = {
    onClick: function() {} // eslint-disable-line
};

Link.propTypes = {
    url: PropTypes.string.isRequired,
    reactLink: PropTypes.bool,
    onClick: PropTypes.func,
    children: PropTypes.oneOfType([PropTypes.string, PropTypes.object]),
    className: PropTypes.string
};

export default Link;
