import React from 'react';
import PropTypes from 'prop-types';

import {Link} from '@components/Link';
import metrics from '@blocks/metrics';

const LOGOUT_LINK = '/passport?origin=passport_profile&mode=logout&yu=';

export class Logout extends React.Component {
    constructor(props) {
        super(props);
        this.displayName = 'logout';
    }

    shouldComponentUpdate() {
        return false;
    }

    sendMetrics() {
        metrics.send(['Выход из текущей сессии']);
    }

    render() {
        const logoutLink = `${LOGOUT_LINK}${this.props.yandexuid}`;

        return (
            <div>
                <span onMouseDown={this.sendMetrics}>
                    <Link pseudo={false} href={logoutLink}>
                        {i18n('Profile.logout.link')}
                    </Link>
                </span>
            </div>
        );
    }
}

Logout.propTypes = {
    yandexuid: PropTypes.string.isRequired
};
