import React from 'react';
import PropTypes from 'prop-types';
import {MAP_CENTER} from './';
import {getLocale} from '@blocks/common';

function isEveryPointsNear(points) {
    return points
        .map((point) => ({
            longitude: Math.floor(point.longitude * 1000) / 1000,
            latitude: Math.floor(point.latitude * 1000) / 1000
        }))
        .every((point, index, arrPoints) => {
            return point.longitude === arrPoints[0].longitude && point.latitude === arrPoints[0].latitude;
        });
}

class Map extends React.Component {
    getMapUrl() {
        const {width, height, settings, points = []} = this.props;
        const {staticMaps, language = 'ru', tld = 'ru'} = settings;
        const locale = getLocale(language, tld);

        let url = `${staticMaps}/1.x/?l=map&size=${width},${height}&lang=${locale}`;

        if (!points.length) {
            url = `${url}&ll=${MAP_CENTER[tld] || MAP_CENTER.ru}&z=10`;
        } else {
            points.forEach((point, index) => {
                const type = point.id === 'work' || point.id === 'home' ? point.id : 'pmwtm1';

                if (index === 0) {
                    url = `${url}&pt=`;
                } else {
                    url = `${url}~`;
                }

                if (point.longitude && point.latitude) {
                    url = `${url}${point.longitude},${point.latitude},${type}`;
                }
            });

            if (points.length === 1 || isEveryPointsNear(points)) {
                url = `${url}&z=16`;
            }
        }

        return url;
    }

    render() {
        const {className} = this.props;
        const url = this.getMapUrl();

        return (
            <div
                className={`yamap ${className !== 'yamap' ? className : ''}`}
                style={{backgroundImage: `url('${url}')`}}
            />
        );
    }
}

Map.defaultProps = {
    id: 'map',
    className: 'yamap',
    width: 628,
    height: 210
};

Map.propTypes = {
    className: PropTypes.string,
    settings: PropTypes.shape({
        staticMaps: PropTypes.string.isRequired,
        language: PropTypes.string.isRequired,
        tld: PropTypes.string.isRequired
    }),
    points: PropTypes.array,
    width: PropTypes.number,
    height: PropTypes.number
};

export default Map;
