import api from '@blocks/api';
import {setYamoneyInfo, setYamoneyInfoProgressState} from './actions';

export default function getYamoneyInfo() {
    return function(dispatch, getState) {
        const state = getState() || {};
        const {common = {}} = state;
        const {csrf} = common;

        dispatch(setYamoneyInfoProgressState(true));
        api.request('get.yamoneyinfo', {csrf})
            .fail(() => {
                dispatch(setYamoneyInfoProgressState(false));
            })
            .done((response) => {
                dispatch(setYamoneyInfo(response));
            });
    };
}
