import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';
import metrics from '@blocks/metrics.js';
import getYamoneyInfo from './';
import {BILLING_METRICS_PREFIX} from '@blocks/morda/billing_info';

export class Money extends Component {
    componentDidMount() {
        this.props.dispatch(getYamoneyInfo());
    }

    sendMetrics = (linkText) => {
        metrics.send([BILLING_METRICS_PREFIX, linkText]);
    };

    render() {
        const tld = (this.props.settings && this.props.settings.tld) || 'ru';
        const money = this.props.yamoney || {};
        const moneyReg = `https://money.yandex.${tld}/reg`;
        const moneyCard = `https://money.yandex.${tld}/card/card-payment/about`;
        const moneyBase = `https://money.yandex.${tld}`;

        let linkHref, linkText;

        if (money.connectionError) {
            linkHref = moneyBase;
            linkText = i18n('Profile.money.gotomoney');
        } else if (money.hasWallet) {
            linkHref = moneyCard;
            linkText = i18n('Profile.money.gotocard');
        } else {
            linkHref = moneyReg;
            linkText = i18n('Profile.money.openwallet');
        }

        return (
            <div>
                <div className='p-control-link'>
                    <span onMouseDown={() => this.sendMetrics(linkText)}>
                        {Boolean(money.connectionError) && <Link href={linkHref}>{linkText}</Link>}
                        {Boolean(!money.connectionError && money.hasWallet) && <Link href={linkHref}>{linkText}</Link>}
                        {Boolean(!money.connectionError && !money.hasWallet) && <Link href={linkHref}>{linkText}</Link>}
                    </span>
                </div>

                {Boolean(!money.connectionError && !money.hasWallet) && (
                    <div className='section-body-info section-body-info__bottom_shift'>
                        {i18n('Profile.money.info')}
                    </div>
                )}
            </div>
        );
    }
}

Money.propTypes = {
    settings: PropTypes.shape({
        tld: PropTypes.string
    }).isRequired,
    dispatch: PropTypes.func.isRequired,
    yamoney: PropTypes.object
};
